﻿﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessManager.TBI;
using System.Runtime.InteropServices;
using Telerik.Web.UI;


public partial class TBI_Instruments_Optimal : BaseTBIInstrumentPage
{

    #region Variable Declarations

    PatientManager patientManager = new PatientManager();
    InstrumentType instrumentType = new InstrumentType();
    private const string FailedFormValuesName = "OptimalFailedFormValues";
    private const string DeferredMessageKeyName = "OptimalDeferredMessageKey";

    protected int _surveyTypeId = 34; // Database Id for Optimal

    SURVEY _survey;   // the root object in the Survey set
    SURVEY_RESULT _surveyResult; // the object representing the actual data in the Survey


    protected List<string> _oneAnswers, _FiveDFiveAAnswers;

    List<STD_QUESTION> QuestionList = new List<STD_QUESTION>();

    #endregion


    /// <summary>
    /// Default Constructor
    /// </summary>
    public TBI_Instruments_Optimal()
    {
        //Manager Save Notification Event Handler
        patientManager.BOSaveSuccess += manager_BOSaveSuccess;
    }

    #region Protected Methods



    /// <summary>
    /// Page Load Method
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Page_Load(object sender, EventArgs e)
    {
        TBIServiceTO _tbiServiceTo;

        try
        {
            // confirm instrument is active - if not, a redirect will occur.
            this.CheckActiveStatus(_surveyTypeId);

            _oneAnswers = new List<string>(10);
            _FiveDFiveAAnswers = new List<string>(8);

            _tbiServiceTo = (TBIServiceTO)Session["TBIServiceTO"];
            _tbiInstrumentManager.TbiServiceTo = _tbiServiceTo;

            string instTitle = _tbiInstrumentManager.GetInstrumentByID(_surveyTypeId).Name;

            LabelBreadCrumb.Text = "TBI Instruments > Instrument Associations > " + instTitle;
            LabelInstrumentTitle.Text = instTitle;
            Page.Title = "TBI Instruments - " + instTitle;

            if (_tbiInstrumentManager.TbiServiceTo != null)
            {
                Label labelUser = (Label)Master.FindControl("LabelCurrentUser");
                labelUser.Text = _tbiInstrumentManager.TbiServiceTo.UserName;

                LabelPatient.Text = _tbiInstrumentManager.TbiServiceTo.PatientName;
                LabelSSN.Text = _tbiInstrumentManager.TbiServiceTo.PatientSnum;
            }
        }
        catch (Exception ex)
        {
            //Redirect to message that session is ended and need to log back in from CPRS.
            Exception _tbilogerror = HandleTBIException(ex, "Optimal.aspx", "100027", "SESSIOENDED");
            Response.Redirect("Warning.aspx?err=2", false);
        }

        if (!IsPostBack)
        {
            if (instrumentType.Status != null)
            {
                _tbiInstrumentManager.TbiServiceTo.SelectedInstrumentType = instrumentType;
            }

            string _snum = "";
            if (_tbiInstrumentManager.TbiServiceTo != null)
            {
                _snum = _tbiInstrumentManager.TbiServiceTo.PatientSnum;
            }

            if (!string.IsNullOrEmpty(_snum))
            {
                string patICN = patientManager.GetPatientICNBySSN(_snum);

                if (!string.IsNullOrEmpty(patICN))
                {
                    ViewState["PatientICN"] = patICN;
                    RefreshSurvey(patICN);
                }
                else
                {
                    throw new ArgumentException("Patient with this SSN does not exist.");
                }

                if (_survey != null && !_survey.isNew)
                {
                    SetUpSurvey(_survey);
                }
                string referrer = "";
                if (Request.UrlReferrer != null)
                {
                    referrer = Request.UrlReferrer.PathAndQuery;
                }
                ViewState["referrer"] = referrer;
            }

            //Check if the request is to start a new item 
            //a new item page request is signified when the querystring parameter id equals zero or is not present
            if (_tbiInstrumentManager.TbiServiceTo == null)
            {
                Logging.WriteLogToFile("Optimal.Page_Load(): WarningRedirect: _tbiInstrumentManager.TbiServiceTo == null");
                //Redirect to message that session is ended and need to log back in from CPRS.
                Response.Redirect("Warning.aspx?err=2");
            }
            else
            {
                LabelPatient.Text = _tbiInstrumentManager.TbiServiceTo.PatientName;
                string _SSN = _tbiInstrumentManager.TbiServiceTo.PatientSnum.Trim().Length == 9 ? String.Format("{0:000-00-0000}", int.Parse(_tbiInstrumentManager.TbiServiceTo.PatientSnum)) : _tbiInstrumentManager.TbiServiceTo.PatientSnum;
                //LabelFacility.Text = _tbiInstrumentManager.TbiServiceTo.InstitutionName;
                LabelSSN.Text = "*****" + _SSN.Substring(7, 4);
            }


        }

        QuestionList = GetAllQuestionsForSurvey();

        // Set control values for Diagnosis Question
        ctrlDiagnosis.QuestionText = GetQuestionText("DX");
        ctrlDiagnosis.SurveyTypeCode = HiddenSurveyType.Value;

        dpDate1.MaxDate = DateTime.Now;

    }


    bool preventNotification = false;

    private InstrumentType selectedInstrumentType;

    protected void Page_Init(object sender, EventArgs e)
    {
        selectedInstrumentType = _tbiInstrumentManager.GetInstrumentByID(_surveyTypeId);
        VeteransAffairs.Registries.QuestionChoiceRetriever.Reset(_tbiInstrumentManager, _surveyTypeId);
    }

    protected void Page_Unload(object sender, EventArgs e)
    {
        VeteransAffairs.Registries.QuestionChoiceRetriever.Reset(null, -1);
    }

    protected void Page_PreRenderComplete(object sender, EventArgs e)
    {
        Dictionary<string, string> cache;
        preventNotification = Request.UrlReferrer.ToString().Contains("InstrumentSummaryNote");
        if(preventNotification!=true)
        { 
            if (!Page.IsPostBack && Helpers.SetupPageFromCache(this, FailedFormValuesName, out cache))
            {
                SuppressSaveMessage = false;
                SaveFailMessage = "Unable to save the survey.\r\n\r\nThere may be network issues preventing you from saving.\r\n\r\nPlease try to submit your changes again.";
                RenderStartUpMessage(false);
            }
            else if (Page.IsPostBack && !preventNotification)
            {
                DeferredMessage = "Save was Successful!";
            }
            else if (DeferredMessage != null)
            {
                SuppressSaveMessage = false;
                SaveSuccessMessage = DeferredMessage;
                RenderStartUpMessage(true);
                DeferredMessage = null;
            }
        }
    }

    protected override void OnPreRender(EventArgs e)
    {
        base.OnPreRender(e);
    }

    private static string DeferredMessage
    {
        get { return HttpContext.Current.Session[DeferredMessageKeyName] as string; }
        set { HttpContext.Current.Session[DeferredMessageKeyName] = value; }
    }
    
 



    protected override void LoadViewState(object savedState)
    {
        base.LoadViewState(savedState);
        string surveyXml = (string)ViewState["surveyXml"];
        _survey = SerializerUtil.Deserialize<SURVEY>(surveyXml);

    }



    protected override object SaveViewState()
    {
        ViewState["surveyXml"] = _survey.Serialize();
        return base.SaveViewState();
    }

    /// <summary>
    /// Returns the Question_Text of the question with the passed Question_Number field
    /// </summary>
    /// <param name="questionId"></param>
    /// <returns></returns>
    protected string GetQuestionText(string questionId)
    {
        foreach (STD_QUESTION ques in QuestionList)
        {
            if (ques.QUESTION_NUMBER.ToLower() == questionId.ToLower())
            {
                if (ques.QUESTION_NUMBER.ToLower().ToString().Contains("baseline difficulty-"))
                {
                    return ques.QUESTION_NUMBER.ToLower().ToString().Replace("baseline difficulty-", "") + ". " + ques.QUESTION_TEXT;
                }
                else
                {
                    return ques.QUESTION_TEXT;
                }
            }
        }

        return "";
    }

    /// <summary>
    /// Returns the Question_Id of the question with the passed Question_Number field
    /// </summary>
    /// <param name="questionId"></param>
    /// <returns></returns>
    protected int GetQuestionId(string questionNumber)
    {
        foreach (STD_QUESTION ques in QuestionList)
        {
            if (ques.QUESTION_NUMBER.ToLower() == questionNumber.ToLower())
            {
                return ques.ID;
            }
        }

        return 0;
    }

    /// <summary>
    /// Save Draft button clicked.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    public void btnSaveSurveyDraft_Click(object sender, EventArgs e)
    {
        Int32 status = 0;
        SaveFailMessage = "Save Failed. Please press " + btnSaveSurveyDraft.Text + " button again to avoid data loss.";
        SaveCompleteSurvey(ref status);
        Response.Redirect("Optimal.aspx", false); //Follow Save Draft logic 
    }

    /// <summary>
    /// Save and Prepare Note button clicked.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnSubmit_Click(object sender, EventArgs e)
    {
        Int32 status = 0;
        SaveFailMessage = "Save Failed. Please press " + btnSubmitSurvey.Text + " button again to avoid data loss.";
        SaveCompleteSurvey(ref status);

        if (status > 0)
        {
            Session["survey"] = _survey;
            Response.Redirect("InstrumentSummaryNote.aspx", false);
        }
        else
        {
            Response.Redirect(Request.Url.PathAndQuery, false); //Follow Save Draft logic 
        }
    }

    /// <summary>
    /// Inactive timer firing.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void InActiveTimer_Tick(object sender, EventArgs e)
    {
        Int32 status = 0;
        SaveFailMessage = "Save Failed. Please press " + btnSaveSurveyDraft.Text + " button again to avoid data loss.";

        Page.Validate();

        if (Page.IsValid)
        {
            SaveCompleteSurvey(ref status);
            SetUpSurvey(_survey);
            Response.Redirect("Optimal.aspx", false);
        }
        else
        {
            SaveFailMessage = "Auto-Save Validation Failed. Please complete required fields in the survey and press " + btnSaveSurveyDraft.Text + " button again to avoid data loss.";
        }
    }

    /// <summary>
    /// Cancel button clicked.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnCancel_Click(object sender, EventArgs e)
    {
        ViewState["surveyXml"] = null;
        ViewState["PatientICN"] = null;
        ViewState["referrer"] = null;
        Session.Remove("survey");
        Response.Redirect("Instrument.aspx", false);
        //this.ClientScript.RegisterStartupScript(typeof(Page), "closePage", "<script type='text/javascript'> window.open('','_self','');window.close(); </script>");
    }

    /// <summary>
    /// Fired when scoring is updated.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void updateTotals(object sender, EventArgs e)
    {
        calculateTotals();
    }

    #endregion

    #region Private Methods

    /// <summary>
    /// Get all questions for this survey
    /// </summary>
    /// <returns></returns>
    private List<STD_QUESTION> GetAllQuestionsForSurvey()
    {
        return _tbiInstrumentManager.SelectAllQuestions(_surveyTypeId).ToList();
    }

    /// <summary>
    /// Refresh Survey
    /// </summary>
    /// <param name="patientICN"></param>
    private void RefreshSurvey(string patientICN)
    {
        var surveys = _tbiInstrumentManager.SelectByPatientICNAndSurveyType(patientICN, _surveyTypeId, true).ToList();

        if (surveys.Count > 0)
        {
            //SetUpSurvey(_survey);
            _survey = surveys.First();
        }
        else
        {
            _survey = new SURVEY();
        }

        _survey.SetAsChangeTrackingRoot();
    }

    /// <summary>
    /// Save Complete Survey
    /// </summary>
    /// <param name="status"></param>
    private void SaveCompleteSurvey(ref Int32 status)
    {
        //Page.Validate();
        //if (Page.IsValid)
        //{

            calculateTotals();

            string patientICN = String.Empty;

            status = 0;

            //Retrieve patient's ICN from the session variable
            if (ViewState["PatientICN"] != null)
            {
                patientICN = ViewState["PatientICN"].ToString();
                if (String.IsNullOrEmpty(patientICN.Trim()))
                {
                    Logging.WriteLogToFile("Optimal.SaveCompletedSurvey(): WarningRedirect: String.IsNullOrEmpty(patientICN.Trim()");
                    //Lost state. Redirect to message that need to log back in from CPRS.
                    Response.Redirect("Warning.aspx?err=2", false);
                }
            }
            else
            {
                Logging.WriteLogToFile("Optimal.SaveCompletedSurvey(): WarningRedirect: ViewState[PatientICN] != null");
                //Lost state. Redirect to message that need to log back in from CPRS.
                Response.Redirect("Warning.aspx?err=2");
            }

            if (_survey != null)
            {
                if (_survey.isNew)
                {
                    //Ensure that a concurrent session hasn't already inserted a record for this survey
                    var surveys = _tbiInstrumentManager.SelectByPatientICNAndSurveyType(patientICN, _surveyTypeId, true).ToList();

                    if (surveys.Count > 0)
                    {
                        Logging.WriteLogToFile("Optimal.SaveCompletedSurvey(): WarningRedirect: surveys.Count > 0");
                        //A concurrent session has already inserted a record for this survey and it is not new anymore.
                        Response.Redirect("Warning.aspx?err=9", false);
                    }
                    else
                    {
                        _survey.SURVEY_STATUS = "inprocess";

                        _survey.SetAsInsertOnSubmit();

                        _survey.patient_ICN = patientICN;

                        _survey.STD_SURVEY_TYPE_ID = _surveyTypeId;

                        // TODO: change to datepicker
                        _survey.SURVEY_DATE = DateTime.Today;

                        //Save survey if it's new before adding any responses
                        SuppressSaveMessage = true;
                        _tbiInstrumentManager.Update(_survey);
                        SuppressSaveMessage = false;

                        RefreshSurvey(patientICN);
                    }
                }

                SaveSurvey(ref _survey);

                _survey.SetAsUpdateOnSubmit();
                status = _tbiInstrumentManager.Update(_survey);

                ((RegistryInstrumentMaster)Master).SetDirtyFlag(false);

                RefreshSurvey(patientICN);
                SuppressSaveMessage = false;

            }
        }
   // }

    /// <summary>
    /// Save survey.
    /// </summary>
    /// <param name="survey"></param>
    /// 
    private void SaveSurvey(ref SURVEY survey)
    {
        //first, mark all current answers for deletion
        survey.SetAsChangeTrackingRoot();
        foreach (SURVEY_RESULT tempResult in survey.SURVEY_RESULTs)
            tempResult.SetAsDeleteOnSubmit();

        

        _surveyResult = new SURVEY_RESULT();

        try
        {
            string varChoice = ctrlDiagnosis.GetSelectedResultText();
            if(!(string.IsNullOrEmpty(varChoice)))
            { 
                // Add Question DX choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(ctrlDiagnosis.GetSelectedId());
                _surveyResult.RESULT_TEXT = ctrlDiagnosis.GetSelectedResultText();
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
        }
        catch (Exception surveyEx)
        {
            Exception _tbilogerror = HandleTBIException(surveyEx, "Optimal.aspx", "100027", "SaveSurvey() - Question DX");
        }
        try
        {

            string varID = getChoiceID("Total Score");

            if (!(string.IsNullOrEmpty(varID)))
            {
                // Total Score
                string tScore = lblBasicActivitiesScore.Text;
                if (!(string.IsNullOrEmpty(tScore)) && tScore!="0")
                {
                    _surveyResult = new SURVEY_RESULT();
                    _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(varID);
                    _surveyResult.RESULT_TEXT = lblBasicActivitiesScore.Text;
                    survey.SURVEY_RESULTs.Add(_surveyResult);
                }
            }
        }
        catch (Exception surveyEx)
        {
            Exception _tbilogerror = HandleTBIException(surveyEx, "RehabFollowUp.aspx", "100027", "SaveSurvey() - Rehabilitation Setting");
        }
        //Save pnlStatus
        Helpers.SaveRadBtnListAnswers(pnlStatus, survey);
        SaveChkListAns(pnlStatus, survey);
        //collect the textboxes if they are populated

        //Save pnlQuestions
        Helpers.SaveRadBtnListAnswers(pnlQuestions, survey);
        //Save pnlBaselineDifficulty
        Helpers.SaveRadBtnListAnswers(pnlBaselineDifficulty, survey);

        //Save pnlDropDownLists (have to do this because Calculate totals refreshing Q24)
        SaveDropDownListAnswers(pnlDropDownLists, survey);



    }// END SaveSurvey

    public static void SaveChkListAns(Panel panel, SURVEY survey)
    {
        String sWork = "";
        String sUse = "";
        String sWhom = "";
        SURVEY_RESULT _surveyResult;
        foreach (Control ctrl in panel.Controls)
        {
            if (ctrl is TextBox)
            {
                TextBox tBox = (TextBox)ctrl;
                //String ctlTB=ctrl.ID
                if (ctrl.ID == "txtWork")
                {
                    sWork = tBox.Text;
                }
                if (ctrl.ID == "txtUse")
                {
                    sUse = tBox.Text;
                }
                if (ctrl.ID == "txtWhom")
                {
                    sWhom = tBox.Text;
                }
            }
        }
        foreach (Control ctrl in panel.Controls)
        {
            if (ctrl is CheckBoxList)
            {
                CheckBoxList chbx = (CheckBoxList)ctrl;

                for (int i = 0; i < ((CheckBoxList)ctrl).Items.Count; i++)
                {
                    if (chbx.Items[i].Selected)
                    {
                        if (i < chbx.Items.Count - 1)
                        {
                            _surveyResult = new SURVEY_RESULT();
                            _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(chbx.Items[i].Value);
                            survey.SURVEY_RESULTs.Add(_surveyResult);
                        }
                        if(i==chbx.Items.Count-1)
                        {
                            //_surveyResult = new SURVEY_RESULT();
                            //_surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(chbx.Items[i].Value);
                            String schoiceID = chbx.Items[i].Value;
                            String chkbxName = chbx.ID;

                            switch (chkbxName)
                            {
                                case "chbx1":
                                    if (schoiceID == chbx.Items[chbx.Items.Count - 1].Value && !String.IsNullOrEmpty(sWork))
                                    {
                                        _surveyResult = new SURVEY_RESULT();
                                        _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(chbx.Items[i].Value);
                                        _surveyResult.RESULT_TEXT = sWork;
                                        survey.SURVEY_RESULTs.Add(_surveyResult);
                                    }
                                    break;
                                case "chbx2":
                                    if (schoiceID == chbx.Items[chbx.Items.Count - 1].Value && !String.IsNullOrEmpty(sUse))
                                    {
                                        _surveyResult = new SURVEY_RESULT();
                                        _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(chbx.Items[i].Value);
                                        _surveyResult.RESULT_TEXT = sUse;
                                        survey.SURVEY_RESULTs.Add(_surveyResult);
                                    }
                                    break;
                                case "chbx3":
                                    if (schoiceID == chbx.Items[chbx.Items.Count - 1].Value && !String.IsNullOrEmpty(sWhom))
                                    {
                                        _surveyResult = new SURVEY_RESULT();
                                        _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(chbx.Items[i].Value);
                                        _surveyResult.RESULT_TEXT = sWhom;
                                        survey.SURVEY_RESULTs.Add(_surveyResult);
                                    }
                                    break;
                                default:
                                    //_surveyResult = new SURVEY_RESULT();
                                    //_surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(chbx.Items[i].Value);
                                    //_surveyResult.RESULT_TEXT = chbx.Items[i].Text;
                                    break;
                            }
                        }
                    }
                }
            }
        }
    }
    public String getChoiceID(String QuestionNumber)
    {
        List<STD_QUESTION_CHOICE> choiceList = new List<STD_QUESTION_CHOICE>();
        choiceList = getChoiceDetails(QuestionNumber);
        String s = "";
        foreach (STD_QUESTION_CHOICE choice in choiceList)
        {
            if (choice.CHOICE_NAME == QuestionNumber)
            {
                s = Convert.ToString(choice.STD_QUESTION_CHOICE_ID);
            }

        }

        return s;
    }

    private List<STD_QUESTION_CHOICE> getChoiceDetails(String QuestionNumber)
    {
        return _tbiInstrumentManager.GetChoicesByQuestionNumberandSurveyType(QuestionNumber, "Optimal");

    }
    private void setUpRadioButtons(Panel panel, SURVEY survey)
    {

        String _sControlID = "";


        foreach (var sResult in survey.SURVEY_RESULTs)
        {
            String s = sResult.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER;
            if (s.Contains("Baseline Difficulty-"))
            {
                _sControlID = s.Replace("Baseline Difficulty-", "rblQdifficulty");
            }
            if (s.Contains("Baseline Confidence-"))
            {
                _sControlID = s.Replace("Baseline Confidence-", "rblQconfidence");
                //_sControlID = _sControlID + "c";
            }
            if (s == "4")
            {
                _sControlID = "rbl4";
            }
            if (s == "Panel Status")
            {
                _sControlID = "rbps";
            }
            foreach (Control ctrl in panel.Controls)
            {
                if (ctrl is RadioButtonList)
                {
                    RadioButtonList rbl = (RadioButtonList)ctrl;
                    try
                    {
                        if (rbl.ID == _sControlID)
                        {
                            rbl.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();


                        }
                    }
                    catch (Exception surveyEx)
                    {
                        Exception _tbilogerror = HandleTBIException(surveyEx, "Optimal.aspx", "100027", "setUpRadioButtons");
                    }
                }
            }
        }

    }


    private void setUpCheckLists(Panel panel, SURVEY survey)
    {
        String _sControlID = "";
        foreach (var sResult in survey.SURVEY_RESULTs)
        {
            String s = sResult.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER;
            _sControlID = "chbx" + s;

            foreach (Control ctrl in panel.Controls)
            {
                if (ctrl is CheckBoxList)
                {
                    CheckBoxList chbx = (CheckBoxList)ctrl;
                    try
                    {
                        if (chbx.ID == _sControlID)
                        {
                            foreach (ListItem item in chbx.Items)
                            {
                                if (item.Value == sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString())
                                {
                                    item.Selected = true;

                                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString() == chbx1.Items[chbx1.Items.Count - 1].Value)
                                    { txtWork.Text = sResult.RESULT_TEXT; txtWork.Visible = true; }

                                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString() == chbx2.Items[chbx2.Items.Count - 1].Value)
                                    { txtUse.Text = sResult.RESULT_TEXT; txtUse.Visible = true; }

                                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString() == chbx3.Items[chbx3.Items.Count - 1].Value)
                                    { txtWhom.Text = sResult.RESULT_TEXT; txtWhom.Visible = true; }

                                }
                            }
                        }
                    }
                    catch (Exception surveyEx)
                    {
                        Exception _tbilogerror = HandleTBIException(surveyEx, "Optimal.aspx", "100027", "setUpCheckLists");
                    }
                }
            }
        }
    }

    private void setUpDropDownLists(Panel panel, SURVEY survey)
    {
        String _sControlID = "";
        String _marked = "";
        int x = 0;

        //foreach (Control ctrl in panel.Controls)
        //{
        //   if (ctrl is DropDownList)
        //  {
        //     DropDownList ddl = (DropDownList)ctrl;
        //}
        //}

        foreach (Control ctrl in panel.Controls)
        {
            if (ctrl is DropDownList)
            {
                DropDownList ddl = (DropDownList)ctrl;
                try
                {
                    x = x + 1;


                    _marked = "";
                    foreach (var sResult in survey.SURVEY_RESULTs)
                    {
                        String s = sResult.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER;
                        if (s.Contains("Baseline Difficulty-23"))
                        {
                            _sControlID = s.Replace("Baseline Difficulty-", "dd");
                        }
                        if (s.Contains("Baseline Difficulty-24"))
                        {
                            _sControlID = s.Replace("Baseline Difficulty-24", "ddPrimaryGoal");
                        }
                        if (ddl.ID == _sControlID && _sControlID.Contains("dd"))
                        {
                            var mI = ((DropDownList)ctrl).Items.Count;
                            for (int i = 0; i < ((DropDownList)ctrl).Items.Count; i++)
                            {
                                if (ddl.Items[i].Value == sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString())
                                {
                                    ddl.Items[i].Selected = true;
                                    i = mI;
                                    if (_sControlID.Contains("23"))
                                    {
                                        ddPrimaryGoal.Items.Add(sResult.STD_QUESTION_CHOICE.CHOICE_TEXT);
                                        ddPrimaryGoal.Items[ddPrimaryGoal.Items.Count].Value = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                                    }
                                    _marked = "1";

                                }
                            }
                        }
                        if (ddl.ID == _sControlID && _sControlID.Contains("q"))
                        {
                            if (dd23a.SelectedItem.Value == qcid.Value)
                            {
                                ddl.Items.Add(new ListItem(dd23a.SelectedItem.Text, qcid.Value));
                            }
                            else
                            {
                                ddl.Items.Add(new ListItem(dd23a.SelectedItem.Text, dd23a.SelectedItem.Value));
                            }
                            if (dd23b.SelectedItem.Value == qcid.Value)
                            {
                                ddl.Items.Add(new ListItem(dd23b.SelectedItem.Text, qcid.Value));
                            }
                            else
                            {
                                ddl.Items.Add(new ListItem(dd23b.SelectedItem.Text, dd23b.SelectedItem.Value));
                            }
                            if (dd23c.SelectedItem.Value == qcid.Value)
                            {
                                ddl.Items.Add(new ListItem(dd23c.SelectedItem.Text, qcid.Value));
                            }
                            else
                            {
                                ddl.Items.Add(new ListItem(dd23c.SelectedItem.Text, dd23c.SelectedItem.Value));
                            }

                            foreach (ListItem item in ddl.Items)
                            {
                                if (item.Value == sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString())
                                {
                                    item.Selected = true;

                                }
                            }
                        }

                        if (_marked == "1")
                        {
                            break;
                        }
                    }
                }
                catch (Exception surveyEx)
                {
                    Exception _tbilogerror = HandleTBIException(surveyEx, "Optimal.aspx", "100027", "setUpCheckLists");
                }

            }
        }
    }

    /// <summary>
    /// Initialize/setup controls
    /// </summary>
    /// <param name="survey"></param>
    private void SetUpSurvey(SURVEY survey)
    {
        try
        {
            chbx1.DataBind();
            chbx2.DataBind();
            chbx3.DataBind();
            rbl4.DataBind();
            dd23a.DataBind();
            dd23b.DataBind();
            dd23c.DataBind();
            ddPrimaryGoal.DataBind();

            //check con first
            if (survey.SURVEY_RESULTs.Count > -1)
            {
                /*foreach (var sResult in survey.SURVEY_RESULTs)
                {
                    String s = sResult.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER;
                    if (s.Contains("Baseline Difficulty-24"))
                    {
                        

                    }
                }*/
            

                setUpCheckLists(pnlStatus, survey);
                setUpRadioButtons(pnlStatus, survey);
                setUpRadioButtons(pnlQuestions, survey);
                setUpRadioButtons(pnlBaselineDifficulty, survey);
                setUpDropDownLists(pnlDropDownLists, survey);

                foreach (var sResult in survey.SURVEY_RESULTs)
                {

                    switch (sResult.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER)
                    {
                        case "DX":
                            if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                            {
                                ctrlDiagnosis.SelectedChoiceId = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();

                                if (sResult.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower().Contains("other"))
                                {
                                    ctrlDiagnosis.SetOtherDescriptionText(sResult.RESULT_TEXT);
                                }
                            }
                            else
                            {
                                ctrlDiagnosis.SelectedChoiceId = null;
                            }
                            break;

                        // Patient Status

                        case "Patient Status":
                            if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                            {
                                rbps.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                            }
                            else
                            {
                                rbps.SelectedIndex = -1;
                            }
                            break;
                        case "Total Score":
                            if (!String.IsNullOrEmpty(sResult.RESULT_TEXT))
                            {
                                lblBasicActivitiesScore.Text = sResult.RESULT_TEXT;
                            }
                            break;
                        case "Baseline Difficulty-24":
                            qcid.Value = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                            qt.Value = sResult.STD_QUESTION_CHOICE.CHOICE_TEXT.ToString();
                            break;
                        default:
                            break;
                    }
                }

            }
        }
        catch (Exception ex)
        {
            Exception _tbilogerror = HandleTBIException(ex, "Optimal.aspx", "100027", "SetUpSurvey()");
        }
    }

    private string GetInstrumentTitle(int surveyID)
    {
        string ret = String.Empty;

        try
        {
            List<string> instrumentTitle = _tbiInstrumentManager.GetInstrumentByID(surveyID).Title;
            if (instrumentTitle.Count > 0)
            {
                foreach (string titleLine in instrumentTitle)
                {
                    if (titleLine.Contains("PhD"))
                    {
                        ret = ret + "<small>" + titleLine + "</small>" + "<br \\>";
                    }
                    else
                    {
                        ret = ret + titleLine + "<br \\>";
                    }
                }
            }

        }
        catch (Exception ex)
        {
            Exception _tbilogerror = HandleTBIException(ex, "Optimal.aspx", "100027", "GetInstrumentTitle()");
            // Ignore error
        }

        return ret;
    }

    /// <summary>
    /// performs total calcuation
    /// </summary>
    private void calculateTotals()
    {
        #region calculate basic

        int basicScore = 0;

        foreach (Control ctrl in pnlBaselineDifficulty.Controls)
        {
            if (ctrl is RadioButtonList)
            {
                RadioButtonList rbl = (RadioButtonList)ctrl;

                for (int i = 0; i < ((RadioButtonList)ctrl).Items.Count-1; i++)
                {

                    if ((rbl.Items[i].Selected) && (i != 5))
                    {
                        try
                        {
                            basicScore += i + 1;
                        }
                        catch (Exception surveyEx)
                        {
                            Exception _tbilogerror = HandleTBIException(surveyEx, "Optimal.aspx", "100027", "calculateTotals()- Baseline Difficulty");
                        }

                    }
                }
            }
        }

        lblBasicActivitiesScore.Text = basicScore.ToString();
        lblScore.Text = basicScore.ToString();


        #endregion


        HiddenBasicScore.Value = basicScore.ToString();

    }

    #endregion


    //Replaces calls to GetChoicesByQuestionNumberandSurveyType
    private List<STD_QUESTION_CHOICE> GetQuestionChoices(string questionNumber)
    {
        return VeteransAffairs.Registries.QuestionChoiceRetriever.GetQuestionChoices(questionNumber);
    }


    private void SaveCheckAnswer(STD_QUESTION_CHOICE choice, List<string> answerList)
    {
        if (!IsNotAsked(choice.CHOICE_TEXT))
        {
            answerList.Add(choice.STD_QUESTION_CHOICE_ID.ToString());
        }
    }

    private void SaveDropDownListAnswers(Panel panel, SURVEY survey)
    {


        foreach (Control ctrl in panel.Controls)
        {
            if (ctrl is DropDownList)
            {
                DropDownList ddl = (DropDownList)ctrl;
                if (ddl.ID != "q24")
                {
                    for (int i = 1; i < ((DropDownList)ctrl).Items.Count; i++)
                    {
                        if (ddl.SelectedIndex == i)
                        {

                            try
                            {

                                if (ddl.ID != "ddPrimaryGoal")
                                {
                                    _surveyResult = new SURVEY_RESULT();
                                    _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(ddl.SelectedItem.Value);
                                    _surveyResult.RESULT_TEXT = ddl.SelectedItem.Text;
                                    survey.SURVEY_RESULTs.Add(_surveyResult);
                                }
                                else
                                {
                                    _surveyResult = new SURVEY_RESULT();
                                    _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(ddl.SelectedItem.Value);
                                    _surveyResult.RESULT_TEXT = ddl.SelectedItem.Text;
                                    survey.SURVEY_RESULTs.Add(_surveyResult);

                                }
                            }
                            catch (Exception surveyEx)
                            {
                                Exception _tbilogerror = HandleTBIException(surveyEx, "Optimal.aspx", "100027", "SaveSurvey() - SaveDropDownListAnswers");
                            }

                        }
                    }
                }
            }
        }
    }

    private bool IsNotAsked(string s)
    {
        if (string.IsNullOrEmpty(s))
            return false;
        return s.IndexOf("not asked", StringComparison.OrdinalIgnoreCase) != -1;
    }



    protected void chbx2_OnDataBound(object sender, EventArgs e)
    {
        foreach (ListItem item in chbx2.Items)
        {
            // item.Selected = ShouldItemBeSelectedMethod(item.Value);
        }
    }



}
